uniform sampler2D tex;
uniform float colorize_saturation;
uniform float colorize_strength;
uniform float colorize_brightness;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
	vec4 color = gl_Color;

	vec4 texColor = texture2D(tex, uv.xy);
	float bw = (texColor.r+texColor.g*2.0+texColor.b)/4.0;

	color.r = color.r*bw*colorize_strength + (1.0-colorize_strength)*texColor.r;
	color.g = color.g*bw*colorize_strength + (1.0-colorize_strength)*texColor.g;
	color.b = color.b*bw*colorize_strength + (1.0-colorize_strength)*texColor.b;

	bw = (1.0-colorize_saturation)*bw;
	color.r = color.r*colorize_saturation + bw;
	color.g = color.g*colorize_saturation + bw;
	color.b = color.b*colorize_saturation + bw;
    
    if (colorize_brightness<0.5)
    {
        color.r = color.r*colorize_brightness*2.0;
        color.g = color.g*colorize_brightness*2.0;
        color.b = color.b*colorize_brightness*2.0;
    }
    else if (colorize_brightness>0.5)
    {
        color.r = (colorize_brightness-0.5)*2.0 + color.r;
        color.g = (colorize_brightness-0.5)*2.0 + color.g;
        color.b = (colorize_brightness-0.5)*2.0 + color.b;
    }

	gl_FragColor = color;
}
